/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.api.event.ClientEvent;
import noppes.npcs.api.mixin.client.gui.IGuiScreenMixin;
import noppes.npcs.client.gui.GuiBoundarySetting;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcMiniWindow;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextArea;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.GuiTextArea;
import noppes.npcs.client.gui.util.IComponentGui;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IEditNPC;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiMenuSideButton;
import noppes.npcs.client.gui.util.IGuiMenuTopButton;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcCheckBox;
import noppes.npcs.client.gui.util.IGuiNpcLabel;
import noppes.npcs.client.gui.util.IGuiNpcMiniWindow;
import noppes.npcs.client.gui.util.IGuiNpcSlider;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiTextArea;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.Poses;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.containers.ContainerEmpty;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.ValueUtil;
import org.lwjgl.input.Keyboard;

public class GuiContainerNPCInterface
extends GuiContainer
implements IEditNPC,
ICustomScrollListener,
ISubGuiListener {
    public static ResourceLocation ball = new ResourceLocation("customnpcs", "textures/gui/info.png");
    public boolean closeOnEsc = false;
    public boolean hoverMiniWin = false;
    public boolean drawDefaultBackground = false;
    protected boolean hasArea = false;
    public int field_147003_i;
    public int field_147009_r;
    public int mouseX;
    public int mouseY;
    public int widthTexture = 0;
    public int heightTexture = 0;
    public int borderTexture = 4;
    public float bgScale = 1.0f;
    public String title = "Npc Mainmenu";
    protected final List<String> hoverText = new ArrayList<String>();
    public ResourceLocation background;
    public EntityNPCInterface npc;
    public EntityPlayerSP player;
    public SubGuiInterface subgui;
    protected final Poses[] ps;
    protected final List<int[]> line = new ArrayList<int[]>();
    protected final List<IComponentGui> components = new ArrayList<IComponentGui>();
    protected final HashMap<Integer, IGuiNpcLabel> labels = new HashMap();
    protected final HashMap<Integer, IGuiCustomScroll> scrolls = new HashMap();
    protected final HashMap<Integer, IGuiNpcSlider> sliders = new HashMap();
    protected final HashMap<Integer, IGuiNpcTextField> textFields = new HashMap();
    protected final HashMap<Integer, IGuiMenuTopButton> topButtons = new HashMap();
    protected final HashMap<Integer, IGuiNpcButton> buttons = new HashMap();
    protected final Map<Integer, IGuiNpcMiniWindow> miniWindows = new ConcurrentHashMap<Integer, IGuiNpcMiniWindow>();

    public GuiContainerNPCInterface(INpc npc, Container cont) {
        this(npc instanceof EntityNPCInterface ? (EntityNPCInterface)npc : null, cont);
    }

    public GuiContainerNPCInterface(EntityNPCInterface npc, Container cont) {
        super(cont);
        this.npc = npc;
        this.field_146297_k = Minecraft.func_71410_x();
        this.player = this.field_146297_k.field_71439_g;
        this.field_146296_j = this.field_146297_k.func_175599_af();
        this.field_146289_q = this.field_146297_k.field_71466_p;
        this.ps = new Poses[]{new Poses((GuiScreen)this, 0), new Poses((GuiScreen)this, 1), new Poses((GuiScreen)this, 2), new Poses((GuiScreen)this, 3), new Poses((GuiScreen)this, 4), new Poses((GuiScreen)this, 5), new Poses((GuiScreen)this, 6), new Poses((GuiScreen)this, 7)};
    }

    @Override
    public void buttonEvent(@Nonnull IGuiNpcButton button, int mouseButton) {
    }

    protected void func_146284_a(@Nonnull GuiButton guibutton) {
        if (!(guibutton instanceof IGuiNpcButton)) {
            return;
        }
        if (this.subgui != null) {
            this.subgui.buttonEvent((IGuiNpcButton)guibutton);
        } else {
            for (IGuiNpcMiniWindow mwin : this.miniWindows.values()) {
                mwin.buttonEvent((IGuiNpcButton)guibutton);
            }
            if (this.hoverMiniWin) {
                return;
            }
            this.buttonEvent((IGuiNpcButton)guibutton);
        }
    }

    @Override
    public void add(IComponentGui component) {
        this.components.add(component);
        if (component instanceof GuiNpcTextArea) {
            this.hasArea = true;
        }
    }

    @Override
    public IComponentGui get(int id) {
        for (IComponentGui component : new ArrayList<IComponentGui>(this.components)) {
            if (component.getID() != id) continue;
            return component;
        }
        return id < this.components.size() ? this.components.get(id) : null;
    }

    public IComponentGui get(int id, Class<?> classType) {
        for (IComponentGui component : new ArrayList<IComponentGui>(this.components)) {
            if (component.getID() != id || !component.getClass().isAssignableFrom(classType)) continue;
            return component;
        }
        return id < this.components.size() ? this.components.get(id) : null;
    }

    public void addButton(GuiNpcButton button) {
        this.addButton((IGuiNpcButton)button);
    }

    @Override
    public void addButton(IGuiNpcButton button) {
        this.buttons.put(button.getID(), button);
        this.add(button);
    }

    @Override
    public IGuiNpcButton addButton(int id, int x, int y, int width, int height, int textureX, int textureY, ResourceLocation texture) {
        GuiNpcButton button = new GuiNpcButton(id, x, y, width, height, textureX, textureY, texture);
        this.addButton((IGuiNpcButton)button);
        return button;
    }

    @Override
    public IGuiNpcButton addButton(int id, int x, int y, int width, int height, int val, String ... display) {
        GuiNpcButton button = new GuiNpcButton(id, x, y, width, height, val, display);
        this.addButton((IGuiNpcButton)button);
        return button;
    }

    @Override
    public IGuiNpcButton addButton(int id, int x, int y, int width, int height, String label) {
        GuiNpcButton button = new GuiNpcButton(id, x, y, width, height, label);
        this.addButton((IGuiNpcButton)button);
        return button;
    }

    @Override
    public IGuiNpcButton addButton(int id, int x, int y, int width, int height, String label, boolean enabled) {
        GuiNpcButton button = new GuiNpcButton(id, x, y, width, height, label, enabled);
        this.addButton((IGuiNpcButton)button);
        return button;
    }

    @Override
    public IGuiNpcButton addButton(int id, int x, int y, int width, int height, String[] display, int val) {
        GuiNpcButton button = new GuiNpcButton(id, x, y, width, height, display, val);
        this.addButton((IGuiNpcButton)button);
        return button;
    }

    @Override
    public IGuiNpcButton addButton(int id, int x, int y, String label) {
        GuiNpcButton button = new GuiNpcButton(id, x, y, label);
        this.addButton((IGuiNpcButton)button);
        return button;
    }

    @Override
    public IGuiNpcButton addButton(int id, int x, int y, String[] display, int val) {
        GuiNpcButton button = new GuiNpcButton(id, x, y, display, val);
        this.addButton((IGuiNpcButton)button);
        return button;
    }

    @Override
    public IGuiNpcCheckBox addCheckBox(int id, int x, int y, int width, int height, String trueLabel, String falseLabel) {
        GuiNpcCheckBox button = new GuiNpcCheckBox(id, x, y, width, height, trueLabel, falseLabel);
        this.addButton(button);
        return button;
    }

    @Override
    public IGuiNpcCheckBox addCheckBox(int id, int x, int y, int width, int height, String trueLabel, String falseLabel, boolean select) {
        GuiNpcCheckBox button = new GuiNpcCheckBox(id, x, y, width, height, trueLabel, falseLabel, select);
        this.addButton(button);
        return button;
    }

    @Override
    public IGuiNpcCheckBox addCheckBox(int id, int x, int y, String trueLabel, String falseLabel, boolean select) {
        GuiNpcCheckBox button = new GuiNpcCheckBox(id, x, y, trueLabel, falseLabel, select);
        this.addButton(button);
        return button;
    }

    public void addLabel(GuiNpcLabel label) {
        this.addLabel((IGuiNpcLabel)label);
    }

    @Override
    public void addLabel(IGuiNpcLabel label) {
        this.labels.put(label.getID(), label);
        this.add(label);
    }

    @Override
    public IGuiNpcLabel addLabel(int id, Object label, int x, int y, int color) {
        GuiNpcLabel iLabel = new GuiNpcLabel(id, label, x, y, color);
        this.addLabel((IGuiNpcLabel)iLabel);
        return iLabel;
    }

    @Override
    public IGuiNpcLabel addLabel(int id, Object label, int x, int y) {
        GuiNpcLabel iLabel = new GuiNpcLabel(id, label, x, y);
        this.addLabel((IGuiNpcLabel)iLabel);
        return iLabel;
    }

    public void addScroll(GuiCustomScroll scroll) {
        this.addScroll((IGuiCustomScroll)scroll);
    }

    @Override
    public void addScroll(IGuiCustomScroll scroll) {
        if (scroll instanceof GuiScreen) {
            ((GuiScreen)scroll).func_146280_a(this.field_146297_k, scroll.getWidth(), scroll.getHeight());
        }
        scroll.setParent(this);
        this.scrolls.put(scroll.getID(), scroll);
        this.add(scroll);
    }

    @Override
    public IGuiCustomScroll addScroll(ICustomScrollListener parent, int scrollId) {
        GuiCustomScroll scroll = new GuiCustomScroll(parent, scrollId);
        this.addScroll((IGuiCustomScroll)scroll);
        return scroll;
    }

    @Override
    public IGuiCustomScroll addScroll(ICustomScrollListener parent, boolean setSearch, int id) {
        GuiCustomScroll scroll = new GuiCustomScroll(parent, setSearch, id);
        this.addScroll((IGuiCustomScroll)scroll);
        return scroll;
    }

    @Override
    public IGuiCustomScroll addScroll(ICustomScrollListener parent, int id, boolean isMultipleSelection) {
        GuiCustomScroll scroll = new GuiCustomScroll(parent, id, isMultipleSelection);
        this.addScroll((IGuiCustomScroll)scroll);
        return scroll;
    }

    public void addSlider(GuiNpcSlider slider) {
        this.addSlider((IGuiNpcSlider)slider);
    }

    @Override
    public void addSlider(IGuiNpcSlider slider) {
        this.sliders.put(slider.getID(), slider);
        this.add(slider);
    }

    public void addTextField(GuiNpcTextField textField) {
        this.addTextField((IGuiNpcTextField)textField);
    }

    @Override
    public void addTextField(IGuiNpcTextField textField) {
        this.textFields.put(textField.getID(), textField);
        this.add(textField);
    }

    public void addTopButton(GuiMenuTopButton button) {
        this.topButtons.put(button.field_146127_k, button);
        this.add(button);
    }

    public void addMiniWindow(GuiNpcMiniWindow miniwindows) {
        this.addMiniWindow((IGuiNpcMiniWindow)miniwindows);
    }

    @Override
    public void addMiniWindow(IGuiNpcMiniWindow miniwindows) {
        this.miniWindows.put(miniwindows.getID(), miniwindows);
        miniwindows.resetButtons();
        this.add(miniwindows);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
    }

    @Override
    public void close() {
        GuiNpcTextField.unfocus();
        this.save();
        this.player.func_71053_j();
        this.displayGuiScreen(null);
        this.field_146297_k.func_71381_h();
    }

    public void displayGuiScreen(GuiScreen gui) {
        ClientEvent.NextToGuiCustomNpcs event = new ClientEvent.NextToGuiCustomNpcs(this.npc, (GuiScreen)this, gui);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.returnGui == null || event.isCanceled()) {
            return;
        }
        this.field_146297_k.func_147108_a(event.returnGui);
        if (this.field_146297_k.field_71462_r == null) {
            this.field_146297_k.func_71381_h();
        }
    }

    public void func_146276_q_() {
        RenderHelper.func_74518_a();
        if (this.drawDefaultBackground && this.subgui == null) {
            this.postDrawBackground();
            super.func_146276_q_();
            if (this.background != null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
                GlStateManager.func_179152_a((float)this.bgScale, (float)this.bgScale, (float)this.bgScale);
                this.field_146297_k.func_110434_K().func_110577_a(this.background);
                if (this.widthTexture != 0 && this.heightTexture != 0) {
                    int maxRow = ValueUtil.correctInt((int)Math.ceil((float)this.field_147000_g / (float)(this.heightTexture - 2 * this.borderTexture)), 2, 10);
                    int maxCol = ValueUtil.correctInt((int)Math.ceil((float)this.field_146999_f / (float)(this.widthTexture - 2 * this.borderTexture)), 2, 10);
                    int tileWidth = this.field_146999_f / maxCol;
                    int tileHeight = this.field_147000_g / maxRow;
                    int lastTileWidth = this.field_146999_f - tileWidth * (maxCol - 1);
                    int lastTileHeight = this.field_147000_g - tileHeight * (maxRow - 1);
                    int uOffset = (this.widthTexture - 2 * this.borderTexture - tileWidth) / 2;
                    int uMax = this.widthTexture - lastTileWidth;
                    int vOffset = (this.heightTexture - 2 * this.borderTexture - tileHeight) / 2;
                    int vMax = this.heightTexture - lastTileHeight;
                    for (int col = 0; col < maxCol; ++col) {
                        for (int row = 0; row < maxRow; ++row) {
                            this.func_73729_b(col * tileWidth, row * tileHeight, col == 0 ? 0 : (col == maxCol - 1 ? uMax : uOffset), row == 0 ? 0 : (row == maxRow - 1 ? vMax : vOffset), col == maxCol - 1 ? lastTileWidth : tileWidth, row == maxRow - 1 ? lastTileHeight : tileHeight);
                        }
                    }
                } else {
                    this.func_73729_b(0, 0, 0, 0, this.field_146999_f, this.field_147000_g);
                }
                GlStateManager.func_179121_F();
            }
        }
    }

    public void postDrawBackground() {
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, new TextComponentTranslation(this.title, new Object[0]).func_150254_d(), this.field_146294_l / 2, this.field_147009_r - 8, new Color(0xFFFFFF).getRGB());
        if (!this.line.isEmpty()) {
            for (int[] ln : this.line) {
                if (ln == null || ln.length < 6) continue;
                GuiBoundarySetting.drawLine(ln[0], ln[1], ln[2], ln[3], ln[4], ln[5]);
            }
            this.line.clear();
        }
        this.hoverMiniWin = false;
        for (IComponentGui component : new ArrayList<IComponentGui>(this.components)) {
            component.render(this, mouseX, mouseY, partialTicks);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!(component instanceof GuiNpcMiniWindow) || !((GuiNpcMiniWindow)component).hovered) continue;
            this.hoverMiniWin = true;
        }
    }

    @Override
    public void drawNpc(Entity entity, int x, int y, float zoomed, int rotation, int vertical, int mouseFocus) {
        EntityNPCInterface npc = null;
        if (entity instanceof EntityNPCInterface) {
            npc = (EntityNPCInterface)entity;
        }
        if (!(entity instanceof EntityLivingBase)) {
            mouseFocus = 0;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179142_g();
        GlStateManager.func_179109_b((float)(this.field_147003_i + x), (float)(this.field_147009_r + y), (float)50.0f);
        float scale = 1.0f;
        if ((double)entity.field_70131_O > 2.4) {
            scale = 2.0f / entity.field_70131_O;
        }
        GlStateManager.func_179152_a((float)(-30.0f * scale * zoomed), (float)(30.0f * scale * zoomed), (float)(30.0f * scale * zoomed));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        float f2 = entity instanceof EntityLivingBase ? ((EntityLivingBase)entity).field_70761_aq : entity.field_70177_z;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity instanceof EntityLivingBase ? ((EntityLivingBase)entity).field_70759_as : entity.field_70177_z;
        float f6 = mouseFocus == 0 || mouseFocus == 2 ? 0.0f : (float)(this.field_147003_i + x - this.mouseX);
        float f7 = mouseFocus == 0 || mouseFocus == 3 ? 0.0f : (float)(this.field_147009_r + y) - 50.0f * scale * zoomed - (float)this.mouseY;
        int orientation = 0;
        if (npc != null) {
            orientation = npc.ais.orientation;
            npc.ais.orientation = rotation;
        }
        GlStateManager.func_179114_b((float)((float)(-Math.atan(f6 / 400.0f) * 20.0)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(-Math.atan(f7 / 40.0f) * 20.0)), (float)1.0f, (float)0.0f, (float)0.0f);
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70761_aq = rotation;
        }
        entity.field_70177_z = (float)(Math.atan(f6 / 80.0f) * 40.0 + (double)rotation);
        entity.field_70125_A = (float)(-Math.atan(f7 / 40.0f) * 20.0);
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70759_as = entity.field_70177_z;
        }
        this.field_146297_k.func_175598_ae().field_78735_i = 180.0f;
        if (mouseFocus != 0 && vertical != 0) {
            GlStateManager.func_179137_b((double)0.0, (double)(1.0 - Math.cos((double)vertical * 3.14 / 180.0)), (double)0.0);
            GlStateManager.func_179114_b((float)vertical, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        this.field_146297_k.func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70761_aq = f2;
        }
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70760_ar = f2;
        }
        entity.field_70177_z = f3;
        entity.field_70126_B = f3;
        entity.field_70125_A = f4;
        entity.field_70127_C = f4;
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70759_as = f5;
        }
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70758_at = f5;
        }
        if (npc != null) {
            npc.ais.orientation = orientation;
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
    }

    @Override
    public void drawNpc(int x, int y) {
        this.drawNpc((Entity)this.npc, x, y, 1.0f, 0, 0, 1);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.drawMainScreen(mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawMainScreen(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        Container container = this.field_147002_h;
        if (this.subgui != null) {
            this.field_147002_h = new ContainerEmpty();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.field_73735_i = 0.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.subgui != null) {
            this.field_147002_h = container;
            this.subgui.func_73863_a(mouseX, mouseY, partialTicks);
        } else {
            this.func_191948_b(mouseX, mouseY);
        }
        if (this.hoverMiniWin) {
            return;
        }
        if (CustomNpcs.ShowDescriptions && !this.hoverText.isEmpty()) {
            this.drawHoveringText(new ArrayList<String>(this.hoverText), mouseX, mouseY, this.field_146289_q);
            RenderHelper.func_74518_a();
            this.hoverText.clear();
        }
    }

    @Override
    public void drawWait() {
        this.func_73732_a(this.field_146289_q, new TextComponentTranslation("gui.wait", new Object[0]).func_150254_d(), this.field_146297_k.field_71443_c / 2, this.field_146297_k.field_71440_d / 2, CustomNpcs.MainColor.getRGB());
        int pos_0 = (int)Math.floor((double)(this.player.field_70170_p.func_82737_E() % 16L) / 2.0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(ball);
        this.func_73729_b(this.ps[pos_0].x - 1, this.ps[pos_0].y - 1, 0, 12, 6, 6);
        int pos_1 = pos_0 - 1;
        if (pos_1 < 0) {
            pos_1 += 8;
        }
        this.func_73729_b(this.ps[pos_1].x, this.ps[pos_1].y, 6, 12, 5, 5);
        int pos_2 = pos_0 - 2;
        if (pos_2 < 0) {
            pos_2 += 8;
        }
        this.func_73729_b(this.ps[pos_2].x + 1, this.ps[pos_2].y + 1, 11, 12, 4, 4);
        GlStateManager.func_179121_F();
    }

    @Override
    public IGuiTextArea getTextArea(int id) {
        for (IComponentGui component : new ArrayList<IComponentGui>(this.components)) {
            if (!(component instanceof IGuiTextArea) || component.getID() != id) continue;
            return (IGuiTextArea)component;
        }
        return null;
    }

    @Override
    public IGuiNpcButton getButton(int id) {
        return this.buttons.get(id);
    }

    @Override
    public int getEventButton() {
        return ((IGuiScreenMixin)((Object)this)).npcs$getEventButton();
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    @Override
    public IGuiNpcLabel getLabel(int id) {
        return this.labels.get(id);
    }

    @Override
    public ResourceLocation getResource(String texture) {
        return new ResourceLocation("customnpcs", "textures/gui/" + texture);
    }

    @Override
    public IGuiCustomScroll getScroll(int id) {
        return this.scrolls.get(id);
    }

    @Override
    public IGuiNpcSlider getSlider(int id) {
        return this.sliders.get(id);
    }

    @Override
    public SubGuiInterface getSubGui() {
        if (this.hasSubGui() && this.subgui.hasSubGui()) {
            return this.subgui.getSubGui();
        }
        return this.subgui;
    }

    @Override
    public IGuiNpcTextField getTextField(int id) {
        return this.textFields.get(id);
    }

    @Override
    public IGuiMenuTopButton getTopButton(int id) {
        return this.topButtons.get(id);
    }

    @Override
    public IGuiNpcMiniWindow getMiniWindow(int id) {
        return this.miniWindows.get(id);
    }

    @Override
    public boolean hasSubGui() {
        return this.subgui != null;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        GuiNpcTextField.unfocus();
        this.components.clear();
        this.field_146292_n.clear();
        this.buttons.clear();
        this.topButtons.clear();
        this.scrolls.clear();
        this.sliders.clear();
        this.labels.clear();
        this.textFields.clear();
        this.miniWindows.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.subgui != null) {
            this.subgui.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            this.subgui.func_73866_w_();
        }
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.hoverText.clear();
        this.hasArea = false;
    }

    public void initPacket() {
    }

    public boolean isInventoryKey(int i) {
        return i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i();
    }

    @Override
    public boolean isMouseHover(int mX, int mY, int px, int py, int pWidth, int pHeight) {
        return mX >= px && mY >= py && mX < px + pWidth && mY < py + pHeight;
    }

    public void func_73869_a(char c, int i) {
        if (this.subgui != null) {
            this.subgui.func_73869_a(c, i);
            return;
        }
        for (IGuiNpcMiniWindow mwin : this.miniWindows.values()) {
            mwin.customKeyTyped(c, i);
        }
        if (this.hoverMiniWin) {
            return;
        }
        boolean helpButtons = false;
        if (i == 56 || i == 29 || i == 184) {
            helpButtons = Keyboard.isKeyDown((int)35);
        } else if (i == 35) {
            boolean bl = helpButtons = Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)184);
        }
        if (helpButtons) {
            CustomNpcs.ShowDescriptions = !CustomNpcs.ShowDescriptions;
        }
        for (IGuiNpcTextField tf : new ArrayList<IGuiNpcTextField>(this.textFields.values())) {
            tf.customKeyTyped(c, i);
        }
        if (this.closeOnEsc && (i == 1 || i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() && !GuiNpcTextField.isActive())) {
            this.close();
        }
        for (IGuiCustomScroll scroll : new ArrayList<IGuiCustomScroll>(this.scrolls.values())) {
            scroll.customKeyTyped(c, i);
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.subgui != null) {
            this.subgui.func_73864_a(mouseX, mouseY, mouseButton);
            return;
        }
        for (IGuiNpcMiniWindow iGuiNpcMiniWindow : this.miniWindows.values()) {
            iGuiNpcMiniWindow.customMouseClicked(mouseX, mouseY, mouseButton);
        }
        if (this.hoverMiniWin) {
            return;
        }
        for (IGuiNpcTextField iGuiNpcTextField : new ArrayList<IGuiNpcTextField>(this.textFields.values())) {
            if (!iGuiNpcTextField.isEnabled()) continue;
            iGuiNpcTextField.customMouseClicked(mouseX, mouseY, mouseButton);
        }
        if (mouseButton == 0) {
            for (IGuiCustomScroll iGuiCustomScroll : new ArrayList<IGuiCustomScroll>(this.scrolls.values())) {
                iGuiCustomScroll.customMouseClicked(mouseX, mouseY, mouseButton);
            }
        }
        for (IGuiNpcButton iGuiNpcButton : this.buttons.values()) {
            if (!iGuiNpcButton.isHovered()) continue;
            this.buttonEvent(iGuiNpcButton, mouseButton);
            break;
        }
        this.mouseEvent(mouseX, mouseY, mouseButton);
        ArrayList<GuiButton> allButtons = new ArrayList<GuiButton>();
        for (IComponentGui component : new ArrayList<IComponentGui>(this.components)) {
            if (!(component instanceof GuiButton)) continue;
            allButtons.add((GuiButton)component);
        }
        for (GuiButton button : allButtons) {
            if (!button.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
            GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, button, allButtons);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
            this.field_146290_a = button = event.getButton();
            this.field_146290_a.func_146113_a(this.field_146297_k.func_147118_V());
            this.func_146284_a(button);
            if (!this.equals(this.field_146297_k.field_71462_r)) break;
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.getButton(), allButtons));
            break;
        }
        try {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
        catch (Exception exception) {
            LogWriter.error(exception);
        }
    }

    public void mouseEvent(int mouseX, int mouseY, int mouseButton) {
        for (IGuiNpcMiniWindow mwin : this.miniWindows.values()) {
            mwin.mouseEvent(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void save() {
    }

    @Override
    public void setBackground(String texture) {
        this.drawDefaultBackground = true;
        this.background = new ResourceLocation("customnpcs", "textures/gui/" + texture);
        switch (texture) {
            case "bgfilled.png": {
                this.widthTexture = 256;
                this.heightTexture = 256;
                break;
            }
            case "companion_empty.png": {
                this.widthTexture = 172;
                this.heightTexture = 167;
                break;
            }
            case "extrasmallbg.png": {
                this.widthTexture = 176;
                this.heightTexture = 71;
                break;
            }
            case "largebg.png": {
                this.widthTexture = 192;
                this.heightTexture = 231;
                break;
            }
            case "menubg.png": {
                this.widthTexture = 256;
                this.heightTexture = 217;
                break;
            }
            case "smallbg.png": {
                this.widthTexture = 176;
                this.heightTexture = 222;
                break;
            }
            case "standardbg.png": {
                this.widthTexture = 256;
                this.heightTexture = 195;
            }
        }
    }

    @Override
    public void setHoverText(@Nullable List<String> newHoverText) {
        this.hoverText.clear();
        if (newHoverText != null && !newHoverText.isEmpty()) {
            this.hoverText.addAll(newHoverText);
        }
    }

    @Override
    public void setHoverText(@Nullable String text, Object ... args) {
        this.hoverText.clear();
        if (text == null || text.isEmpty()) {
            return;
        }
        if (!text.contains("%")) {
            text = new TextComponentTranslation(text, args).func_150254_d();
        }
        if (text.contains("~~~")) {
            text = text.replaceAll("~~~", "%");
        }
        while (text.contains("<br>")) {
            this.hoverText.add(text.substring(0, text.indexOf("<br>")));
            text = text.substring(text.indexOf("<br>") + 4);
        }
        this.hoverText.add(text);
    }

    @Override
    public void drawHoverText(String text, Object ... args) {
        if (!CustomNpcs.ShowDescriptions) {
            return;
        }
        if (text == null) {
            if (!this.hoverText.isEmpty()) {
                this.drawHoveringText(new ArrayList<String>(this.hoverText), this.mouseX, this.mouseY, this.field_146289_q);
            }
            this.hoverText.clear();
            return;
        }
        this.setHoverText(text, args);
        if (!this.hoverText.isEmpty()) {
            this.drawHoveringText(new ArrayList<String>(this.hoverText), this.mouseX, this.mouseY, this.field_146289_q);
            this.hoverText.clear();
        }
    }

    @Override
    public boolean hasHoverText() {
        return !this.hoverText.isEmpty();
    }

    @Override
    public void setSubGui(SubGuiInterface gui) {
        this.subgui = gui;
        if (this.subgui != null) {
            this.subgui.setNpc(this.npc);
            this.subgui.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            this.subgui.setParent((GuiScreen)this);
            this.subgui.getParent().func_73866_w_();
        }
    }

    public void func_146280_a(@Nonnull Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        this.initPacket();
    }

    public void func_73876_c() {
        if (this.subgui != null) {
            this.subgui.func_73876_c();
        } else {
            for (IComponentGui component : new ArrayList<IComponentGui>(this.components)) {
                if (component instanceof GuiNpcTextField) {
                    ((GuiNpcTextField)component).updateScreen();
                }
                if (!(component instanceof GuiTextArea)) continue;
                ((GuiTextArea)component).updateScreen();
            }
            super.func_73876_c();
        }
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int time, IGuiCustomScroll scroll) {
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
    }

    @Override
    public void mouseDragged(IGuiNpcSlider slider) {
    }

    @Override
    public void mousePressed(IGuiNpcSlider slider) {
    }

    @Override
    public void mouseReleased(IGuiNpcSlider slider) {
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
    }

    @Override
    public void addLine(int sX, int sY, int eX, int eY, int color, int size) {
        this.line.add(new int[]{sX, sY, eX, eY, color, size});
    }

    @Override
    public void closeMiniWindow(IGuiNpcMiniWindow miniWindow) {
        this.miniWindows.remove(miniWindow.getID());
    }

    @Override
    public void setMiniHoverText(int id, IComponentGui component) {
    }

    @Override
    public boolean hasArea() {
        return this.hasArea;
    }

    @Override
    public void addSideButton(IGuiMenuSideButton slider) {
    }

    @Override
    public IGuiMenuSideButton getSideButton(int id) {
        return null;
    }

    @Override
    public void addTopButton(IGuiMenuTopButton button) {
    }

    @Override
    public INpc getNpc() {
        return this.npc;
    }

    @Override
    public void setNpc(INpc iNpc) {
        this.npc = (EntityNPCInterface)iNpc;
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
    }
}

